﻿/* Skript zur Erzeugung von Tabellen
 * Als Benutzer SCOTT ausführen
 */

-- Erstellung einer einfachen Tabelle
create table emp_test(
  emp_id number(5,0),
  last_name varchar2(25 char),
  first_name varchar2(25 char),
  department_id number,
  hire_date date,
  e_mail varchar2(50 char)
);


drop table emp_test;

-- Eine Fassung mit Constraints
create table emp_test(
  emp_id number(5,0)
    constraint emp_pk primary key,
  last_name varchar2(25 char) not null,
  first_name varchar2(25 char) not null,
  department_id number,
  hire_date date,
  e_mail varchar2(50 char) 
    constraint emp_chk_email check (instr(e_mail, '@') > 0),
  constraint emp_dept_fk foreign key (department_id)
    references dept (deptno)
);

-- Vergleich char zu varchar2
create table char_test(
  last_name char(40 byte));
  
insert into char_test
values ('MEYER');

select *
  from char_test
 where last_name = 'MEYER';

select *
  from char_test
 where last_name = lpad('MEYER', 40, ' ');

select *
  from char_test
 where last_name = rpad('MEYER', 40, ' ');

-- Nun lassen wir's krachen: Übergabe eine Variablen
variable v_last_name varchar2(40 byte)
exec :v_last_name := 'MEYER';

select *
  from char_test
 where last_name = :v_last_name;
 
-- Index-organisierte Tabelle
create table salutation(
  salutation_id varchar2(4 char)
    constraint salutation_pk primary key,
  salutation_value varchar2(25 char))
  organization index;
  
-- Einfaches Beispiel für einen Trigger
create or replace trigger trg_emp_briu
before insert or update on emp
   for each row
begin
  if inserting then
    :new.empno := emp_seq.nextval;
  end if;
  if updating then
    :new.ename := :old.ename;
  end if;
  if :new.job = 'SALESMAN' then
    :new.comm := coalesce(:new.comm, :old.comm, 0);
  else
    :new.comm := null;
  end if;
end;
/

-- Test des Triggers
insert into emp (ename, job, sal, deptno)
values ('SCHULZE', 'SALESMAN', 1500, 20);

select empno, ename, job, sal, comm
  from emp
 where ename = 'SCHULZE';
 
update emp
   set ename = 'SCHULTZE',
       job = 'ANALYST'
 where ename = 'SCHULZE';
 
select empno, ename, job, sal, comm
  from emp
 where ename in ('SCHULZE', 'SCHULTZE');
 
rollback;

/* Virtuelle Spalten */
create table virtual_test(
  id number,
  description varchar2(50 char),
  value_1 number,
  value_2 number,
  tot_value number as (value_1 + value_2) virtual,
  constraint pk_virtual_sum primary key (tot_value));

-- Auswirkungen auf die INSERT-Anweisung
-- zu wenig Werte (virtuelle Spalte wird als richtige Spalte interpretiert)
insert into virtual_test
values(1, 'Ein Test', 10, 20);

-- Direkte Zuweisung zu einer virtuellen Spalte ist nicht zulässig
insert into virtual_test
values(1, 'Ein Test', 10, 20, 30);

-- Wir benötigen also eine explizite Spaltenliste:
insert into virtual_test(id, description, value_1, value_2)
values(1, 'Ein Test', 10, 20);

-- Test: Die virtuelle Spalte funktioniert
select *
  from virtual_test;
  
drop table virtual_test;
  